<!-- Page Heading -->
<div class="row">
    <div class="col-lg-12">
        <h1 class="page-header"><?= $title; ?></h1>
        <ol class="breadcrumb">
            <li>
                <i class="fa fa-list-ul" aria-hidden="true"></i> <a href="<?= base_url("index.php/customer"); ?>"><?= $title; ?></a>
            </li>
            <li class="active">
                <i class="fa fa-edit"></i> update customer
            </li>
        </ol>
    </div>
</div>
<!-- /.row -->

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-body">
                <?= form_open_multipart('customer/do_update', array('id' => 'customer', 'class' => 'form-horizontal', 'onsubmit' => 'return false')); ?>
                <div class="form-group">
                    <label class="col-sm-2 control-label">
                        <input type="hidden" id="data_id" name="data_id" value="<?= $data["id"]; ?>">
                    </label>
                    <div class="col-sm-10">
                        <a href="<?= $data["image"]; ?>" class="popupImg">
                            <img src="<?= $data["image"]; ?>" class="img-responsive"/>
                        </a>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Image</label>
                    <div class="col-sm-10">
                        <input id="upload_img" name="upload_img" placeholder="true" data-show-upload="false" type="file" placeholder="Select image..." >
                        <div id="errorBlock" class="help-block"></div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Type
                        <br>
                    </label>
                    <div class="col-sm-10">
                        <div class="radio radio-inline">
                            <input type="radio" id="cus_local" value="0" name="type" <?= $data["type"] == "0" ? "checked" : ""; ?>>
                            <label for="cus_local"> Local </label>
                        </div>
                        <div class="radio radio-inline">
                            <input type="radio" id="cus_overseas" value="1" name="type" <?= $data["type"] == "1" ? "checked" : ""; ?>>
                            <label for="cus_overseas"> Overseas </label>
                        </div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Customer</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="title" name="title" placeholder="Insert customer name..." value="<?= $data["title"]; ?>">
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Link</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="link" name="link" placeholder="Insert link..." value="<?= $data["link"]; ?>">
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Product introduction
                        <br>
                    </label>
                    <div class="col-sm-10">
                        <div class="radio radio-danger radio-inline">
                            <input type="radio" id="introduction_hide" value="0" name="introduction" <?= $data["introduction"] == "0" ? "checked" : ""; ?> />
                            <label for="introduction_hide"> No </label>
                        </div>
                        <div class="radio radio-info radio-inline">
                            <input type="radio" id="introduction_show" value="1" name="introduction" <?= $data["introduction"] == "1" ? "checked" : ""; ?> />
                            <label for="introduction_show"> YES </label>
                        </div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Status
                        <br>
                    </label>
                    <div class="col-sm-10">
                        <div class="radio radio-danger radio-inline">
                            <input type="radio" id="status_hide" value="0" name="status" <?= $data["status"] == "0" ? "checked" : ""; ?> />
                            <label for="status_hide"> Hide </label>
                        </div>
                        <div class="radio radio-info radio-inline">
                            <input type="radio" id="status_show" value="1" name="status" <?= $data["status"] == "1" ? "checked" : ""; ?> />
                            <label for="status_show"> Show </label>
                        </div>
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Create date</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="<?= $data["create_date"]; ?>" disabled="" />
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <?php if ($data["modify_date"] != "00/00/0000 00:00:00") { ?>
                    <div class="form-group">
                        <label class="col-sm-2 control-label">Modify date</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" value="<?= $data["modify_date"]; ?>" disabled="" />
                        </div>
                    </div>
                    <div class="hr-dashed"></div>
                <?php } ?>
                <div class="form-group">
                    <label class="col-sm-2 control-label">Employee modify</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" value="<?= $data["employee"]; ?>" disabled="" />
                    </div>
                </div>
                <div class="hr-dashed"></div>
                <div class="form-group" style="display: none;" id="blog_error">
                    <label class="col-sm-2 control-label"></label>
                    <div class="col-sm-10">
                        <div class="alert alert-danger" role="alert">
                            <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
                            <span class="sr-only">Error:</span><span id="txt_error"></span>
                        </div>
                    </div>
                </div>
                <div class="progress" style="display: none;">
                    <div class="progress-bar progress-bar-success progress-bar-striped" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width:0%"></div>
                </div>
                <div class="form-group">
                    <div class="col-sm-8 col-sm-offset-2">
                        <button class="btn btn-success" type="submit" onclick="customer('update');"><i class="fa fa-floppy-o" aria-hidden="true"></i> Save</button>
                        <button class="btn btn-default" type="reset"><i class="fa fa-ban" aria-hidden="true"></i> Cancel</button>
                    </div>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>