<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Iso_cer_model extends CI_Model {

    protected $table = "iso_cer";

    public function __construct() {
        parent::__construct();
    }

    public function create() {
        $response = array();
        $rank = count($this->get_all()) + 1;
        $fields = array(
            'title' => htmlspecialchars($_POST["title"]),
            'status' => $_POST["status"],
            'rank' => $rank,
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->insert($this->table, $fields);
        $data = $this->get_by_id($this->db->insert_id());
        if (!empty($_FILES["upload_img"]["name"])) {
            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/iso_cer/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/iso_cer/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function update() {
        $response = array();
        $id = $_POST["data_id"];
        $fields = array(
            'title' => htmlspecialchars($_POST["title"]),
            'status' => $_POST["status"],
            'rank' => $_POST["rank"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->where('id', $id);
        $this->db->update($this->table, $fields);

        $data = $this->get_by_id($id);

        if (!empty($_FILES["upload_img"]["name"])) {
            @unlink($data["image"]);
            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/iso_cer/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/iso_cer/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function delete($id) {
        $data = $this->get_by_id($id);
        $this->db->query("DELETE FROM " . $this->table . " WHERE id = '" . $id . "'");
        if (!empty($data["image"])) {
            delete_files($data["image"]);
        }

        return "success";
    }

    public function get_by_id($id) {
        $response = array();
        $sql = "SELECT
                i.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS i
              INNER JOIN employee AS e
                ON i.employee_id = e.id
              WHERE i.id='" . $id . "'
              ORDER BY i.rank ASC, i.id DESC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $response["id"] = $row["id"];
            $response["title"] = htmlspecialchars_decode($row["title"]);
            $response["image"] = htmlspecialchars_decode($row["image"]);
            $response["rank"] = $row["rank"];
            $response["status"] = $row["status"];
            $response["create_date"] = format_date_thai($row["create_date"]);
            $response["modify_date"] = format_date_thai($row["modify_date"]);
            $response["employee"] = $row["firstname"] . " " . $row["lastname"];
        }

        return $response;
    }

    public function get_all() {
        $response = array();
        $sql = "SELECT
                i.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS i
              INNER JOIN employee AS e
                ON i.employee_id = e.id
              ORDER BY i.rank ASC, i.id DESC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            array_push($response, array(
                "id" => $row["id"],
                "title" => htmlspecialchars_decode($row["title"]),
                "image" => htmlspecialchars_decode($row["image"]),
                "rank" => $row["rank"],
                "status" => $row["status"],
                "create_date" => format_date_thai($row["create_date"]),
                "modify_date" => format_date_thai($row["modify_date"]),
                "employee" => $row["firstname"] . " " . $row["lastname"]
            ));
        }

        return $response;
    }

}
