<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Customer_model extends CI_Model {

    protected $table = "customer";

    public function __construct() {
        parent::__construct();
    }

    public function create() {
        $response = array();
        $fields = array(
            'title' => $_POST["title"],
            'link' => $_POST["link"],
            'type' => $_POST["type"],
            'introduction' => $_POST["introduction"],
            'status' => $_POST["status"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->insert($this->table, $fields);
        $data = $this->get_by_id($this->db->insert_id());
        if (!empty($_FILES["upload_img"]["name"])) {
            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/customer/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/customer/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function update() {
        $response = array();
        $id = $_POST["data_id"];
        $fields = array(
            'title' => $_POST["title"],
            'link' => $_POST["link"],
            'type' => $_POST["type"],
            'introduction' => $_POST["introduction"],
            'status' => $_POST["status"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->where('id', $id);
        $this->db->update($this->table, $fields);

        $data = $this->get_by_id($id);
        if (!empty($_FILES["upload_img"]["name"])) {

            @unlink($data["image"]);

            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/customer/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/customer/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function delete($id) {
        $data = $this->get_by_id($id);
        $this->db->query("DELETE FROM " . $this->table . " WHERE id = '" . $id . "'");
        if (!empty($data["image"])) {
            delete_files($data["image"]);
        }
        
        return "success";
    }

    public function get_by_id($id) {
        $response = array();

        $sql = "SELECT
                c.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS c
              INNER JOIN employee AS e
                ON c.employee_id = e.id
              WHERE c.id = '" . $id . "'";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $response["id"] = $row["id"];
            $response["title"] = $row["title"];
            $response["image"] = $row["image"];
            $response["link"] = $row["link"];
            $response["type"] = $row["type"];
            $response["introduction"] = $row["introduction"];
            $response["status"] = $row["status"];
            $response["create_date"] = format_date_thai($row["create_date"]);
            $response["modify_date"] = format_date_thai($row["modify_date"]);
            $response["employee"] = htmlspecialchars_decode($row["firstname"]) . " " . htmlspecialchars_decode($row["lastname"]);
        }

        return $response;
    }

    public function get_all() {
        $response = array();

        $sql = "SELECT
                c.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS c
              INNER JOIN employee AS e
                ON c.employee_id = e.id
              ORDER BY c.id ASC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            array_push($response, array(
                "id" => $row["id"],
                "title" => $row["title"],
                "image" => $row["image"],
                "link" => $row["link"],
                "type" => $row["type"],
                "introduction" => $row["introduction"],
                "status" => $row["status"],
                "create_date" => format_date_thai($row["create_date"]),
                "modify_date" => format_date_thai($row["modify_date"]),
                "employee" => htmlspecialchars_decode($row["firstname"]) . " " . htmlspecialchars_decode($row["lastname"])
            ));
        }

        return $response;
    }

}
