<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Categories_model extends CI_Model {

    protected $table = "categories";

    public function __construct() {
        parent::__construct();
    }

    public function create() {
        $response = array();
        $rank = count($this->get_all()) + 1;
        $fields = array(
            'title' => htmlspecialchars($_POST["title"]),
            'rank' => $rank,
            'status' => $_POST["status"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->insert($this->table, $fields);
        $data = $this->get_by_id($this->db->insert_id());


        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function update() {
        $response = array();
        $id = $_POST["data_id"];
        $fields = array(
            'title' => htmlspecialchars($_POST["title"]),
            'rank' => $_POST["rank"],
            'status' => $_POST["status"],
            'modify_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->where('id', $id);
        $this->db->update($this->table, $fields);

        $data = $this->get_by_id($id);

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function delete($id) {
        $query = $this->db->query("DELETE FROM " . $this->table . " WHERE id = '" . $id . "'");
        $this->db->query("DELETE FROM sub_categories WHERE categories_id = '" . $id . "'");
        if ($query) {
            $query_s = $this->db->query("SELECT * FROM sub_categories WHERE categories_id = '" . $id . "'");
            foreach ($query_s->result_array() as $row_s) {
                $query_p = $this->db->query("SELECT * FROM products WHERE sub_cate_id = '" . $row_s["id"] . "'");
                foreach ($query_p->result_array() as $row_p) {
                    delete_files($row_p["image"]);
                    delete_files($row_p["pdf"]);
                }
                $this->db->query("DELETE FROM products WHERE sub_cate_id = '" . $row_s["id"] . "'");
            }
            $this->db->query("DELETE FROM sub_categories WHERE categories_id = '" . $id . "'");
        }

        return "success";
    }

    public function get_by_id($id) {
        $response = array();

        $sql = "SELECT
                c.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS c
              INNER JOIN employee AS e
                ON c.employee_id = e.id
              WHERE c.id = '" . $id . "'";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $response["id"] = $row["id"];
            $response["title"] = htmlspecialchars_decode($row["title"]);
            $response["rank"] = $row["rank"];
            $response["status"] = $row["status"];
            $response["create_date"] = format_date_thai($row["create_date"]);
            $response["modify_date"] = format_date_thai($row["modify_date"]);
            $response["employee"] = htmlspecialchars_decode($row["firstname"]) . " " . htmlspecialchars_decode($row["lastname"]);
        }

        return $response;
    }

    public function get_all() {
        $response = array();

        $sql = "SELECT
                c.*,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS c
              INNER JOIN employee AS e
                ON c.employee_id = e.id
              ORDER BY c.rank ASC, c.id ASC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            array_push($response, array(
                "id" => $row["id"],
                "title" => htmlspecialchars_decode($row["title"]),
                "rank" => $row["rank"],
                "status" => $row["status"],
                "create_date" => format_date_thai($row["create_date"]),
                "modify_date" => format_date_thai($row["modify_date"]),
                "employee" => htmlspecialchars_decode($row["firstname"]) . " " . htmlspecialchars_decode($row["lastname"])
            ));
        }

        return $response;
    }

}
