<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Reference extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "certificates";
        $this->data["sub_menu"] = "";
        $this->load->model("reference_model", "reference");
    }

    public function index() {
        $this->data["title"] = "Reference";
        $this->data["data"] = $this->reference->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('reference/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "Reference";
        $this->load->view('template/header', $this->data);
        $this->load->view('reference/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->reference->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "Reference";
        $this->data["data"] = $this->reference->get_by_id($id);
        $this->load->view('template/header', $this->data);
        $this->load->view('reference/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->reference->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->reference->delete($id);

        echo json_encode($data);
    }

}
