<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Iso_cer extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "certificates";
        $this->data["sub_menu"] = "";
        $this->load->model("iso_cer_model", "iso");
    }

    public function index() {
        $this->data["title"] = "iso";
        $this->data["data"] = $this->iso->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('iso/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "iso";
        $this->load->view('template/header', $this->data);
        $this->load->view('iso/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->iso->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "iso";
        $this->data["data"] = $this->iso->get_by_id($id);
        $this->load->view('template/header', $this->data);
        $this->load->view('iso/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->iso->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->iso->delete($id);

        echo json_encode($data);
    }

}
