<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Certificates extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "certificates";
        $this->data["sub_menu"] = "";
        $this->load->model("certificates_model", "certificates");
    }

    public function index() {
        $this->data["title"] = "Certificates";
        $this->data["data"] = $this->certificates->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('certificates/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "Certificates";
        $this->load->view('template/header', $this->data);
        $this->load->view('certificates/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->certificates->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "Certificates";
        $this->data["data"] = $this->certificates->get_by_id($id);
        $this->load->view('template/header', $this->data);
        $this->load->view('certificates/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->certificates->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->certificates->delete($id);

        echo json_encode($data);
    }

}
