<?php
include("config/config.php");
include("./include/doc_type.php");
?>

<!-- product_slide-->
<link rel="stylesheet" type="text/css" href="/th/css/slick.css"/th/>
<link rel="stylesheet" type="text/css" href="/th/css/slick-theme.css"/th/>
<script type="text/javascript" src="/th/js/slick.js"></script>
<script type="text/javascript" >
	$(document).ready(function() {
		$('.slide').slick({
				infinite: true,
				speed: 500,
				arrows: false,
				dots: true,
				autoplay: true
		});
		
		$('.responsive').slick({
				infinite: true,
				speed: 500,
				autoplaySpeed: 4000,
				autoplay: true,
				slidesToShow: 4,
				slidesToScroll: 1,
				responsive: [{
						breakpoint: 768,
						settings: {
								slidesToShow: 3,
								slidesToScroll: 1
						}
				}, {
						breakpoint: 420,
						settings: {
								slidesToShow: 2,
								slidesToScroll: 1
						}
				}]
		});
		
		$('.banner_logo').slick({
				infinite: true,
				speed: 500,
				arrows: false,
				autoplay: true,
				pauseOnHover: false,
				slidesToShow: 5,
				slidesToScroll: 1,
				responsive: [{
						breakpoint: 768,
						settings: {
								slidesToShow: 4,
								slidesToScroll: 1
						}
				}, {
						breakpoint: 420,
						settings: {
								slidesToShow: 3,
								slidesToScroll: 1
						}
				}]
		});
	});
</script>

</head>
<body class="drawer drawer--right drawer--navbarTopGutter">
<div id="wrapper">

	<?php
	include("./include/header.php");
	?>


	<main>
		<div class="page_index">
			<div id="main_img_wrap">
				<div id="main_img" class="clearfix">
					<ul class="slide">
						<?php
						$sql_banner = "SELECT * FROM banner WHERE status='1' ORDER BY id DESC";
						$obj_banner = $Database->to_array($Database->query($sql_banner));
						if(!empty($obj_banner[0]["id"])){
							foreach ($obj_banner as $row) {
								?>
								<li><a href="<?= $row["link"] == "" ? "#" : $row["link"] ;?>"><img src="<?= $row["image"] ;?>" alt=""></a></li>
								<?php
							}
						}
						?>
					</ul>
				</div><!--/main_img-->
			</div><!--/main_img_wrap-->
	
			<div id="product">
				<div class="box">
					<h2><img class="switch" src="/images/index/title_product_pc.png" alt="PRODUCTS"></h2>
					<ul class="responsive">
						<?php
						$sql_product = "SELECT * FROM products WHERE status='1' AND introduction='1' ORDER BY rank ASC, id DESC";
						$obj_product = $Database->to_array($Database->query($sql_product));
						if(!empty($obj_product[0]["id"])){
							foreach ($obj_product as $row) {
								?>
								<li>
									<a href="/th/products/detail.php?id=<?= $row["id"] ;?>" class="imghover">
										<img src="<?= $row["image"] ;?>" alt="">
										<span class="name_p"><?= htmlspecialchars_decode($row["title"]) ;?></span>
										<span class="detail_p"><?= htmlspecialchars_decode($row["short_detail"]) ;?></span>
									</a>
								</li>
								<?php
							}
						}
						?>
					</ul>					
				</div><!-- /.box -->				
			</div><!-- /#product -->
			
			<div id="about" class="section">
				<div class="box">
					<h3><img class="switch" src="/th/images/index/title_about_pc.png" alt="ABOUT US"></h3>
					<p class="item">
						กุลธรไฟฟ้า จำกัด เดิมชื่อ บริษัท กุลธรสากลไฟฟ้า จำกัด เป็น บริษัท ร่วมทุนระหว่างกลุ่ม บริษัท กุลธรของ บริษัท และ Universal ไฟฟ้า จำกัด ของสหรัฐอเมริกาตั้งแต่ปี 1987 ด้วยการสนับสนุนทางด้านเทคนิคจากยูนิเวอร์แซไฟฟ้า Co. , LTD. บริษัท ของเราเป็นหนึ่งในโรงงานมอเตอร์ที่ทันสมัยที่สุดในเอเชีย
					</p>
					<p>
						ข้อตกลงใบอนุญาตที่ถูก expried ในเดือนเมษายน 2000 และทำให้ บริษัท กุลธรสากลไฟฟ้า จำกัด กลายเป็น บริษัท ไทยในปีที่เมษายน 15,2000 หลังจาก Magnetek ขายหุ้นใน บริษัท กุลธรสากลไฟฟ้า จำกัด เพื่อกุลธรอินเตอร์เนชั่นแนล จำกัด
					</p>
				</div><!-- /.box -->	
			</div><!-- /#about -->
			
			<div class="box clearfix section">
				<div id="video">
					<h3 class="tittle_top"><img src="/th/images/index/title_vdo.png" alt="VDO PRESENTATION"></h3>
					<?php
					$sql_vdo = "SELECT * FROM vdo";
					$obj_vdo = $Database->to_array($Database->query($sql_vdo));
					$link = explode("?v=", $obj_vdo[0]["link"]);
					?>
					<iframe src="https://www.youtube.com/embed/<?= $link[1] ;?>" frameborder="0" allowfullscreen></iframe>
				</div><!-- /#video -->
				<div id="news">
					<div class="news_box container">
						<h3 class="tittle_top"><img src="/images/index/title_news.png" alt="NEWS UPDATE"></h3>
						<a href="/th/news/#news_box" class="btn_list">LIST MORE</a>
						<?php
						$sql_news = "SELECT * FROM news WHERE status='1' ORDER BY news.create DESC, id DESC LIMIT 1";
						$obj_news = $Database->to_array($Database->query($sql_news));
						if(!empty($obj_news[0]["id"])){
							?>
							<div class="pic_l clearfix">
								<div class="img">
									<a href="/th/news/detail_news.php?id=<?= $obj_news[0]["id"] ;?>"><img class="imghover" src="<?= $obj_news[0]["image"] ;?>" alt=""></a>
								</div>
								<div class="msg">
									<em><?= ShortDate($obj_news[0]["create_date"]) ;?></em>
									<span><a href="/th/news/detail_news.php?id=<?= $obj_news[0]["id"] ;?>"><?= htmlspecialchars_decode($obj_news[0]["title_th"]) ;?></a></span>
									<p>
										<?= htmlspecialchars_decode($obj_news[0]["short_detail_th"]) ;?></a>
									</p>
								</div>
							</div><!-- /.container -->
							<?php
						}
						?>
					</div><!-- /.news_box -->
					
					<div class="news_box techno_box container">
						<h3 class="tittle_top"><img src="/images/index/title_technology.png" alt="TECHNOLOGY"></h3>
						<a href="/th/news/#event_box" class="btn_list">LIST MORE</a>
						<?php
						$sql_events = "SELECT * FROM events WHERE status='1' ORDER BY events.create DESC, id DESC LIMIT 1";
						$obj_events = $Database->to_array($Database->query($sql_events));
						if(!empty($obj_events[0]["id"])){
							?>
							<div class="pic_l clearfix">
								<div class="img">
									<a href="/th/news/detail_event.php?id=<?= $obj_events[0]["id"] ;?>"><img class="imghover" src="<?= $obj_events[0]["image"] ;?>" alt=""></a>
								</div>
								<div class="msg">
									<em><?= ShortDate($obj_events[0]["create_date"]) ;?></em>
									<span><a href="/th/news/detail_event.php?id=<?= $obj_events[0]["id"] ;?>"><?= htmlspecialchars_decode($obj_events[0]["title_th"]) ;?></a></span>
									<p>
										<?= htmlspecialchars_decode($obj_events[0]["short_detail_th"]) ;?></a> 
									</p>
								</div>
							</div><!-- /.container -->
							<?php
						}
						?>
					</div><!-- /.news_box -->
				</div><!-- /#news -->
			</div><!-- /.box -->
		</div><!-- /.page_index -->
	</main><!--/main-->
	
	<div id="banner">
		<ul class="banner_logo">
			<?php
			$sql_cus_intro = "SELECT * FROM customer WHERE status='1' AND introduction='1' ORDER BY id ASC";
			$obj_cus_intro = $Database->to_array($Database->query($sql_cus_intro));
			if(!empty($obj_cus_intro[0]["id"])){
				foreach ($obj_cus_intro as $row) {
					$cus_link = "javascript:void(0);";
					if($row["link"] != ""){
							$cus_link = $row["link"];
					}
					
					?>
					<li><a href="<?= $cus_link;?>" class="imghover" target="_blank"><img src="<?= $row["image"] ;?>" alt="<?= htmlspecialchars_decode($row["title"] );?>" title="<?= htmlspecialchars_decode($row["title"] );?>"></a></li>
					<?php
				}
			}
			?>
		</ul>
	</div><!-- /#banner -->
		
	<?include("./include/footer.php");?>	
</div><!--/wrapper-->
</body>
</html>