<?php

class Database {

    public $config;
    public $connection;
    public $SORTING_MIN_TO_MAX;
    public $SORTING_MAX_TO_MIN;

    public function __construct() {
        
    }

    public function connect() {
        $this->connection = mysql_connect($this->config['mysql']['serverName'], $this->config['mysql']['username'], $this->config['mysql']['password']) or die("Can't connect Server");

        mysql_select_db($this->config['mysql']['databaseName']) or die("Can't connect databases");

        mysql_query("SET character_set_results=utf8");
        mysql_query("SET character_set_client=utf8");
        mysql_query("SET character_set_connection=utf8");
    }

    public function select_database($database_name) {
        mysql_select_db($database_name);
    }

    public function add($table_name, $data) {
        $data = $this->parse_data_add($data);
        $sql = 'INSERT INTO ' . $table_name . '(' . $data['attr'] . ') VALUES (' . $data['val'] . ')';
        $this->query($sql);
        return mysql_insert_id($this->connection);
    }

    public function update($table_name, $data, $condition = 'NULL') {
        $condition = $this->parse_condition($condition);
        $data = $this->parse_data_update($data);
        $sql = 'UPDATE ' . $table_name . ' SET ' . $data;

        if ($condition != 'NULL') {
            $sql .= ' WHERE ' . $condition;
        }

        $this->query($sql);
    }

    public function remove($table_name, $condition = 'NULL') {
        $condition = $this->parse_condition($condition);

        if ($condition == 'NULL') {
            $sql = 'DELETE FROM ' . $table_name;
        } else {
            $sql = 'DELETE FROM ' . $table_name . ' WHERE ' . $condition;
        }

        $this->query($sql);
    }

    public function query($sql) {
        //echo '<br/>'.$sql.'<br/>'; //debug

        $r = mysql_query($sql);

        if (!$this->error($r, $sql))
            return $r;

        return 'ERROR';
    }

    public function find($table_name, $result, $condition = 'NULL') {
        $condition = $this->parse_condition($condition);
        $condition = ( $condition != 'NULL' ) ? ' WHERE ' . $condition : '';

        $sql = "SELECT $result FROM $table_name $condition";
        $r = $this->to_array($this->query($sql));

        return ( $r ) ? $r : false;
    }

    public function find_to_page($table_name, $result, $condition, $display = 10, $page_menu_number = 9, $page_current = 1, $sorting = 'min') {
        if ($page_current < 1) {
            $page_current = 1;
        }

        $condition = $this->parse_condition($condition);

        $total_data = $this->count_data($table_name, $condition);

        if ($total_data != 0) {
            if ($sorting == 'max') {
                list ( $total_data, $pages, $start, $display, $page_current ) = $this->page_max_to_min($total_data, $display, $page_current);
            } else {
                list ( $total_data, $pages, $start, $display, $page_current ) = $this->page_min_to_max($total_data, $display, $page_current);
            }

            $condition = ( $condition != 'NULL' ) ? ' WHERE ' . $condition : '';
            $sql = "SELECT $result FROM " . $table_name . ' ' . $condition . ' LIMIT ' . $start . ' , ' . $display;
            $result = $this->to_array($this->query($sql));

            if ($sorting == 'max') {
                $result = array_reverse($result);
            }

            $result['menu'] = $this->menu_page($total_data, $display, $page_menu_number, $page_current, $pages);

            return $result;
        }

        return false;
    }

    private function menu_page($total_data, $display, $page_menu_number, $page_cuurent, $pages) {
        $page_cuurent = (int) $page_cuurent;

        if ($total_data > $display) {
            if ($page_cuurent > $pages) {
                $page_cuurent = $pages;
            }

            $half_display = (int) ( $page_menu_number / 2 );
            $befor_page = 0;
            $aftter_page = 0;
            $page_value = array();
            $page_value[] = $page_cuurent;

            for ($i = 1; $i <= $half_display; ++$i) {
                if (( $page_cuurent - $i ) > 0) {
                    $page_value[] = $page_cuurent - $i;
                    ++$befor_page;
                } else {
                    break;
                }
            }

            $add_page = $half_display - $befor_page;

            for ($i = 1; $i <= $half_display + $add_page; ++$i) {
                if (( $page_cuurent + $i ) <= $pages) {
                    $page_value[] = $page_cuurent + $i;
                    $aftter_page++;
                }
            }

            $remove_page = $half_display - $aftter_page;

            for ($i = $remove_page; $i > 0; --$i) {
                if (( $page_cuurent - $befor_page - $i ) > 0) {
                    $page_value[] = $page_cuurent - $befor_page - $i;
                }
            }

            sort($page_value);
            $min = ( $page_value[0] != 1 ) ? 1 : 'NULL';
            $max = ( $page_value[count($page_value) - 1] != $pages ) ? $pages : 'NULL';

            return array('page' => $page_value, 'cureent' => $page_cuurent, 'pages' => $pages, 'min' => $min, 'max' => $max);
        }

        return false;
    }

    private function page_min_to_max($total, $display, $page_current) {
        if ($display > $total) {
            $total = $display;
        }

        $pages = ceil($total / $display);

        if ($page_current > $pages) {
            $page_current = $pages;
        }

        $start = ($page_current - 1) * $display;

        return array($total, $pages, $start, $display, $page_current);
    }

    private function page_max_to_min($total, $display, $page_current) {

        $pages = ceil($total / $display);

        if ($page_current > $pages) {
            $page_current = $pages;
        }
        if ($display > $total) {
            $display = $total;
            $start = 0;
        } else {
            $start = $total - ($display * $page_current);
            if ($start < 0) {
                $display = $display + $start;
                $start = 0;
            }
        }

        return array($total, $pages, $start, $display, $page_current);
    }

    public function count_data($table_name, $condition = 'NULL') {

        $condition = $this->parse_condition($condition);

        if ($condition == 'NULL') {
            $sql = 'SELECT COUNT(*) as r FROM ' . $table_name;
        } else {
            $sql = 'SELECT COUNT(*) as r FROM ' . $table_name . ' WHERE ' . $condition;
        }

        $r = $this->query($sql);

        if ($r == 'ERROR') {
            return 0;
        }

        $r = $this->to_array($r);

        return $r[0]['r'];
    }

    public function to_array($data) {

        if ($data == 'ERROR') {
            return false;
        }

        $arr = array();

        while ($r = mysql_fetch_assoc($data)) {
            $arr[] = $r;
        }

        return ( getType($arr[0]) != 'NULL' ) ? $arr : false;
    }

    public function to_object($data) {

        $arr = array();

        while ($r = mysql_fetch_object($data)) {
            $arr[] = $r;
        }

        return ( getType($arr[0]) != 'NULL' ) ? $arr : false;
    }

    private function parse_data_add($data) {
        $i = 1;
        $count = count($data);
        $attribute = "";
        $value = "";

        foreach ($data as $attribute_item => $value_item) {
            $attribute .= $attribute_item;
            $value .= '"' . $value_item . '"';

            if ($i < $count) {
                $attribute .= ",";
                $value .= ",";
            }

            ++$i;
        }

        return array('attr' => $attribute, 'val' => $value);
    }

    private function parse_data_update($data) {

        $i = 1;
        $count = count($data);
        $r = "";

        foreach ($data as $attribute_item => $value_item) {
            if ($value_item === null) {
                $r .= $attribute_item . ' = null';
            } else {
                $r .= $attribute_item . ' = ' . '"' . $value_item . '"';
            }

            if ($i < $count) {
                $r .= ",";
            }

            ++$i;
        }

        return $r;
    }

    private function to_data_condition($data) {

        $i = 1;
        $count = count($data);
        $r = "";

        foreach ($data as $attribute_item => $value_item) {
            $r .= $attribute_item . ' = ' . '"' . $value_item . '"';

            if ($i < $count) {
                $r .= " AND ";
            }

            ++$i;
        }

        return $r;
    }

    private function parse_condition($condition) {

        if ($condition == 'NULL') {
            return 'NULL';
        } else if (gettype($condition) == 'string') {
            return $condition;
        } else if (gettype($condition) == 'array') {
            return $this->to_data_condition($condition);
        } else {
            return 'NULL';
        }
    }

    public function close() {
        mysql_close($this->connection);
    }

    private function error($susecs, $sql) {

        if ($susecs) {
            return FALSE;
        } else {
            echo '<br>DATABASE ERROR<br>';            //debug
            echo '<br>' . mysql_error();      //debug
            echo '<br> ERROR SQL : ' . $sql . '<br>';  //debug
            return TRUE;
        }
    }

    public function loadConfig($config) {
        $this->config = $config;
    }

}

?>