<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Products_model extends CI_Model {

    protected $table = "products";

    public function __construct() {
        parent::__construct();
    }

    public function create() {
        $response = array();
        $rank = count($this->get_all()) + 1;
        $fields = array(
            'title' => htmlspecialchars($_POST["product"]),
            'model' => htmlspecialchars($_POST["model"]),
            'short_detail' => htmlspecialchars($_POST["short_description"]),
            'detail' => htmlspecialchars($_POST["description"]),
            'categorie_id' => $_POST["categorie"],
            'sub_cate_id' => $_POST["sub_categorie_id"],
            'sub_cate2' => $_POST["sub_categorie2"],
            'introduction' => $_POST["introduction"],
            'rank' => $rank,
            'status' => $_POST["status"],
            'create_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->insert($this->table, $fields);
        $data = $this->get_by_id($this->db->insert_id());
        if (!empty($_FILES["upload_img"]["name"])) {
            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/products/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/products/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }
		
        if (!empty($_FILES["pdf_file"]["name"])) {
            $pdf_name = htmlspecialchars($data["title"] . ".pdf");
            $path_pdf = "./images/pdf/" . $pdf_name;
            if (move_uploaded_file($_FILES['pdf_file']['tmp_name'], $path_pdf)) {
                chmod($path_pdf, 0777);
                $upload_img = array(
                    'pdf' => base_url() . 'images/pdf/' . $pdf_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function update() {        
        $response = array();
        $id = $_POST["data_id"];
        $fields = array(
            'title' => htmlspecialchars($_POST["product"]),
            'model' => htmlspecialchars($_POST["model"]),
            'short_detail' => htmlspecialchars($_POST["short_description"]),
            'detail' => htmlspecialchars($_POST["description"]),
            'categorie_id' => $_POST["categorie"],
            'sub_cate_id' => $_POST["sub_categorie_id"],
            'sub_cate2' => $_POST["sub_categorie2"],
            'introduction' => $_POST["introduction"],
            'rank' => $_POST["rank"],
            'status' => $_POST["status"],
            'modify_date' => date('Y-m-d H:i:s'),
            'employee_id' => $this->session->userdata('employee_id')
        );
        $this->db->where('id', $id);
        $this->db->update($this->table, $fields);

        $data = $this->get_by_id($id);

        if (!empty($_FILES["upload_img"]["name"])) {
            @unlink($data["image"]);
            $type = get_type_image($_FILES["upload_img"]["type"]);
            $img_name = $data["id"] . $type;
            $path_img = "./images/products/" . $img_name;
            if (move_uploaded_file($_FILES['upload_img']['tmp_name'], $path_img)) {
                chmod($path_img, 0777);
                $upload_img = array(
                    'image' => base_url() . 'images/products/' . $img_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }
				
		// print_r($data["pdf"]);
		
        if (!empty($_FILES["pdf_file"]["name"])) {
			$data_unlink = explode("images/pdf/", $data["pdf"]);
            @unlink($data_unlink[1]);
            $pdf_name = htmlspecialchars($data["title"] . "_" . time() . ".pdf");
            $path_pdf = "./images/pdf/" . $pdf_name;
            if (move_uploaded_file($_FILES['pdf_file']['tmp_name'], $path_pdf)) {
                chmod($path_pdf, 0777);
                $upload_img = array(
                    'pdf' => base_url() . 'images/pdf/' . $pdf_name
                );
                $this->db->where('id', $data["id"]);
                $this->db->update($this->table, $upload_img);
            }
        }

        $response["id"] = $data["id"];
        $response["response"] = "success";

        return $response;
    }

    public function delete($id) {
        $data = $this->get_by_id($id);
        $this->db->query("DELETE FROM " . $this->table . " WHERE id = '" . $id . "'");
        if (!empty($data["image"])) {
            delete_files($data["image"]);
        }

        if (!empty($data["pdf"])) {
            delete_files($data["pdf"]);
        }

        return "success";
    }

    public function get_by_id($id) {
        $response = array();
        $sql = "SELECT
                p.*,
                s.title AS categories,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS p
              INNER JOIN sub_categories_2 AS s
                ON p.sub_cate2 = s.id
              INNER JOIN employee AS e
                ON p.employee_id = e.id
              WHERE p.id = '" . $id . "'
              ORDER BY p.id ASC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            $response["id"] = $row["id"];
            $response["title"] = htmlspecialchars_decode($row["title"]);
            $response["model"] = htmlspecialchars_decode($row["model"]);
            $response["image"] = htmlspecialchars_decode($row["image"]);
            $response["short_detail"] = htmlspecialchars_decode($row["short_detail"]);
            $response["detail"] = htmlspecialchars_decode($row["detail"]);
            $response["pdf"] = htmlspecialchars_decode($row["pdf"]);
            $response["introduction"] = $row["introduction"];
            $response["categorie_id"] = $row["categorie_id"];
            $response["sub_cate_id"] = $row["sub_cate_id"];
            $response["sub_cate2"] = $row["sub_cate2"];
            $response["rank"] = $row["rank"];
            $response["status"] = $row["status"];
            $response["create_date"] = format_date_thai($row["create_date"]);
            $response["modify_date"] = format_date_thai($row["modify_date"]);
            $response["employee"] = $row["firstname"] . " " . $row["lastname"];
        }

        return $response;
    }

    public function get_all() {
        $response = array();

        $sql = "SELECT
                p.*,
                s.title AS categories,
                e.firstname,
                e.lastname
              FROM " . $this->table . " AS p
              INNER JOIN sub_categories_2 AS s
                ON p.sub_cate2 = s.id
              INNER JOIN employee AS e
                ON p.employee_id = e.id
              ORDER BY p.rank ASC, p.id ASC";
        $query = $this->db->query($sql);
        foreach ($query->result_array() as $row) {
            array_push($response, array(
                "id" => $row["id"],
                "title" => htmlspecialchars_decode($row["title"]),
                "model" => htmlspecialchars_decode($row["model"]),
                "image" => htmlspecialchars_decode($row["image"]),
                "short_detail" => htmlspecialchars_decode($row["short_detail"]),
                "detail" => htmlspecialchars_decode($row["detail"]),
                "pdf" => htmlspecialchars_decode($row["pdf"]),
                "introduction" => $row["introduction"],
                "categorie_id" => htmlspecialchars_decode($row["categorie_id"]),
                "sub_cate_id" => htmlspecialchars_decode($row["sub_cate_id"]),
                "sub_cate2" => htmlspecialchars_decode($row["sub_cate2"]),
                "categories" => htmlspecialchars_decode($row["categories"]),
                "rank" => $row["rank"],
                "status" => $row["status"],
                "create_date" => format_date_thai($row["create_date"]),
                "modify_date" => format_date_thai($row["modify_date"]),
                "employee" => $row["firstname"] . " " . $row["lastname"]
            ));
        }

        return $response;
    }

}
