<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Products extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "products";
        $this->data["sub_menu"] = "";
        $this->load->model("products_model", "product");
        $this->load->model("categories_model", "categorie");
        $this->load->model("sub_categories_model", "sub_categorie");
        $this->load->model("sub_categories2_model", "sub_categorie2");
    }

    public function index() {
        $this->data["title"] = "products";
        $this->data["data"] = $this->product->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('products/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "products";
        $this->data["categorie"] = $this->categorie->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('products/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->product->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "products";
        $this->data["data"] = $this->product->get_by_id($id);
        $this->data["categorie"] = $this->categorie->get_all();
        $this->data["sub_cate_all"] = $this->sub_categorie->get_sub_by_cate($this->data["data"]["categorie_id"]);
        $this->data["sub_cate2_all"] = $this->sub_categorie2->get_sub_by_cate($this->data["data"]["sub_cate_id"]);
//        $this->data["sub_cate2"] = $this->sub_categorie2->get_by_id($this->data["data"]["sub_cate_id"]);
//        $this->data["sub_cate"] = $this->sub_categorie->get_by_id($this->data["sub_cate2"]["sub_categories_id"]);
//        $this->data["sub_cate_all"] = $this->sub_categorie->get_sub_by_cate($this->data["sub_cate"]["categories_id"]);

        $this->load->view('template/header', $this->data);
        $this->load->view('products/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->product->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->product->delete($id);

        echo json_encode($data);
    }

}
