<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class News extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "news";
        $this->data["sub_menu"] = "";
        $this->load->model("news_model", "news");
    }

    public function index() {
        $this->data["title"] = "news";
        $this->data["data"] = $this->news->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('news/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "news";
        $this->load->view('template/header', $this->data);
        $this->load->view('news/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->news->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "news";
        $this->data["data"] = $this->news->get_by_id($id);
        $this->load->view('template/header', $this->data);
        $this->load->view('news/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->news->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->news->delete($id);

        echo json_encode($data);
    }

}
