<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Events extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "events";
        $this->data["sub_menu"] = "";
        $this->load->model("events_model", "events");
    }

    public function index() {
        $this->data["title"] = "events";
        $this->data["data"] = $this->events->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('events/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "events";
        $this->load->view('template/header', $this->data);
        $this->load->view('events/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->events->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "events";
        $this->data["data"] = $this->events->get_by_id($id);
        $this->load->view('template/header', $this->data);
        $this->load->view('events/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->events->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->events->delete($id);

        echo json_encode($data);
    }

}
