<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Customer extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "customer";
        $this->data["sub_menu"] = "";
        $this->load->model("customer_model", "customer");
    }

    public function index() {
        $this->data["title"] = "customer";
        $this->data["data"] = $this->customer->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('customer/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "customer";
        $this->load->view('template/header', $this->data);
        $this->load->view('customer/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->customer->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "customer";
        $this->data["data"] = $this->customer->get_by_id($id);

        $this->load->view('template/header', $this->data);
        $this->load->view('customer/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->customer->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->customer->delete($id);

        echo json_encode($data);
    }

}
