<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Categories extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        if (!$this->session->userdata('is_login')) {
            redirect(base_url("index.php/admin/login"));
        }

        $this->data["menu"] = "categories";
        $this->data["sub_menu"] = "";
        $this->load->model("categories_model", "categorie");
    }

    public function index() {
        $this->data["title"] = "categories";
        $this->data["data"] = $this->categorie->get_all();
        $this->load->view('template/header', $this->data);
        $this->load->view('categories/index');
        $this->load->view('template/footer');
    }

    public function create() {
        $this->data["title"] = "categories";
        $this->load->view('template/header', $this->data);
        $this->load->view('categories/create');
        $this->load->view('template/footer');
    }

    public function do_create() {
        $data = $this->categorie->create();

        echo json_encode($data);
    }

    public function update($id) {
        $this->data["title"] = "categories";
        $this->data["data"] = $this->categorie->get_by_id($id);

        $this->load->view('template/header', $this->data);
        $this->load->view('categories/update');
        $this->load->view('template/footer');
    }

    public function do_update() {
        $data = $this->categorie->update();

        echo json_encode($data);
    }

    public function delete($id) {
        $data = $this->categorie->delete($id);

        echo json_encode($data);
    }

}
