<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Admin extends CI_Controller {

    public $data = array();

    public function __construct() {
        parent::__construct();
        $this->load->library('session');
        $this->data["menu"] = "admin";
        $this->load->model("admin_model", "admin");
    }

    public function index() {
        $this->load->view('template/header', $this->data);
        $this->load->view('admin/index');
        $this->load->view('template/footer');
    }

    public function login() {
        if ($this->session->userdata('is_login')) {
            redirect(base_url("index.php/home"));
        }

        $this->load->view('admin/login');
    }

    public function do_login() {
        $data = $this->admin->do_login();

        echo json_encode($data);
    }

    public function logout() {
        $data = $this->admin->do_logout();

        echo json_encode($data);
    }

}
